import json, os

CONFIG_PATH = os.path.join(os.path.dirname(__file__), '..', 'config', 'features.json')

def load_flags(path=CONFIG_PATH):
    with open(path, 'r') as f:
        return json.load(f)

def is_enabled(feature_key, flags=None):
    if flags is None:
        flags = load_flags()
    return flags.get('features', {}).get(feature_key, False)

if __name__ == '__main__':
    flags = load_flags()
    print('Loaded flags:', flags.get('meta',{}).get('release'))
