# Luna vL1-D21 Code Bundle (Public-lite)

This bundle contains starter code and infrastructure for the L1-D21 (L1D2.1) public-lite release.
It is intentionally modular and safe — experimental or sensitive components are left as stubs/placeholders for internal validation.

Contents:
- scripts/ingest.py          -- CSV/miniSEED ingest & basic metadata handling
- scripts/spectral_analysis.py -- PSD, STFT, coherence helpers using scipy
- scripts/visualization.py   -- plotting helpers and Compost Equation visual
- tools/feature_flags.py     -- simple feature-flag loader
- api/app.py                 -- FastAPI app for ingestion & feature queries (dev server)
- config/features.json       -- public-lite feature toggles
- ui_stub/                   -- notes for a minimal frontend and placeholder files
- requirements.txt           -- Python dependencies (for development)

INSTRUCTIONS:
1. Create a Python virtualenv and install dependencies: `pip install -r requirements.txt`
2. Run the API locally: `uvicorn api.app:app --reload --port 8000`
3. Use scripts/*.py for analysis and plotting; adapt as needed for production.
